/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.compiler;

import com.jozufozu.flywheel.backend.gl.shader.GlProgram;
import com.jozufozu.flywheel.core.compile.ProgramContext;
import com.jozufozu.flywheel.core.compile.Template;
import com.jozufozu.flywheel.core.compile.VertexData;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.core.source.FileResolution;
import java.util.HashMap;
import java.util.Map;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.coderbot.iris.shaderpack.loading.ProgramId;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.class_2561;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import org.jetbrains.annotations.NotNull;
import top.leonx.irisflw.IrisFlw;
import top.leonx.irisflw.accessors.NewWorldRenderingPipelineAccessor;
import top.leonx.irisflw.accessors.ProgramSourceAccessor;
import top.leonx.irisflw.accessors.WorldProgramAccessor;
import top.leonx.irisflw.flywheel.IrisFlwCompatShaderWarp;

public abstract class IrisProgramCompilerBase<P extends WorldProgram> {
    Map<WorldRenderingPipeline, HashMap<ProgramContext, P>> programCache = new HashMap<WorldRenderingPipeline, HashMap<ProgramContext, P>>();
    Map<WorldRenderingPipeline, HashMap<ProgramContext, P>> shadowProgramCache = new HashMap<WorldRenderingPipeline, HashMap<ProgramContext, P>>();
    protected final GlProgram.Factory<P> factory;
    private static int programCounter = 0;

    public IrisProgramCompilerBase(GlProgram.Factory<P> factory, Template<? extends VertexData> template, FileResolution header) {
        this.factory = factory;
    }

    public P getProgram(ProgramContext ctx, boolean isShadow) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
            HashMap cache = isShadow ? this.shadowProgramCache.computeIfAbsent(pipeline, key -> new HashMap()) : this.programCache.computeIfAbsent(pipeline, key -> new HashMap());
            if (!cache.containsKey(ctx)) {
                P created = this.createIrisShaderProgram(ctx, isShadow);
                cache.put(ctx, created);
                if (created == null && class_310.method_1551().field_1724 != null) {
                    if (isShadow) {
                        class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)String.format("Fail to compile %s_%s_%s", "Shadow", ctx.spec.name.method_12836(), ctx.spec.name.method_12832())), false);
                    } else {
                        class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)String.format("Fail to compile %s_%s_%s", "Gbuffers_flw", ctx.spec.name.method_12836(), ctx.spec.name.method_12832())), false);
                    }
                }
            }
            return (P)((WorldProgram)cache.get(ctx));
        }
        return null;
    }

    private String getFlwShaderName(class_2960 location, boolean isShadow) {
        String randomId = String.valueOf(programCounter);
        ++programCounter;
        if (isShadow) {
            return String.format("shadow_flw_%s_%s_%s", location.method_12836(), location.method_12832(), randomId);
        }
        return String.format("gbuffers_flw_%s_%s_%s", location.method_12836(), location.method_12832(), randomId);
    }

    abstract P createIrisShaderProgram(ProgramContext var1, boolean var2);

    protected P createWorldProgramBySource(ProgramContext ctx, boolean isShadow, NewWorldRenderingPipelineAccessor pipeline, ProgramSource processedSource) {
        class_5944 override = null;
        try {
            override = isShadow ? pipeline.callCreateShadowShader(this.getFlwShaderName(ctx.spec.name, true), processedSource, ProgramId.Block, AlphaTest.ALWAYS, class_290.field_1585, false, false) : pipeline.callCreateShader(this.getFlwShaderName(ctx.spec.name, false), processedSource, ProgramId.Block, AlphaTest.ALWAYS, class_290.field_1585, FogMode.OFF, false, false);
        }
        catch (Exception exception) {
            IrisFlw.LOGGER.error("Fail to compile shader", (Throwable)exception);
        }
        if (override != null) {
            WorldProgram program = (WorldProgram)this.factory.create(ctx.spec.name, override.method_1270());
            ((WorldProgramAccessor)program).setShader(new IrisFlwCompatShaderWarp(override));
            return (P)program;
        }
        return null;
    }

    @NotNull
    protected ProgramSource programSourceOverrideVertexSource(ProgramContext ctx, ProgramSet programSet, ProgramSource source, String vertexSource) {
        ShaderProperties properties = ((ProgramSourceAccessor)source).getShaderProperties();
        BlendModeOverride blendModeOverride = ((ProgramSourceAccessor)source).getBlendModeOverride();
        ProgramSource processedSource = new ProgramSource(source.getName() + "_" + ctx.spec.name.method_12836() + "_" + ctx.spec.name.method_12832(), vertexSource, (String)source.getGeometrySource().orElse(null), (String)source.getFragmentSource().orElse(null), programSet, properties, blendModeOverride);
        return processedSource;
    }

    public void clear() {
        this.programCache.clear();
        this.shadowProgramCache.clear();
    }
}

